<?php
// Conexión a la base de datos
$db_path = 'ads.db';
$images = [];

try {
    $db = new SQLite3($db_path);

    // Obtener todas las URLs de los anuncios (solo las imágenes)
    $res = $db->query('SELECT url FROM ads ORDER BY created_on DESC');
    if ($res === false) {
        throw new Exception($db->lastErrorMsg());
    }

    // Almacenar las URLs de las imágenes
    while ($ad = $res->fetchArray(SQLITE3_ASSOC)) {
        $images[] = $ad['url'];
    }

} catch (Exception $e) {
    echo "Error al conectar con la base de datos: " . $e->getMessage();
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Full Screen Image Slider</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <style>
        /* Estilo para el slider a pantalla completa */
        .carousel-item img {
            width: 100%;
            height: 100vh; /* Esto hace que la imagen cubra toda la altura de la pantalla */
            object-fit: cover; /* La imagen cubrirá toda el área sin distorsionarse */
        }

        /* Fondo oscuro para el slider */
        body {
            background-color: #000; /* Fondo oscuro para contrastar las imágenes */
            color: #fff;
            margin: 0;
        }

        .carousel {
            height: 100vh; /* Hacer el carrusel de altura completa */
        }
    </style>
</head>
<body>

<div id="carouselExampleFade" class="carousel slide carousel-fade" data-ride="carousel">
    <div class="carousel-inner">
        <?php if (count($images) > 0): ?>
            <?php foreach ($images as $index => $image): ?>
                <div class="carousel-item <?php echo $index === 0 ? 'active' : ''; ?>">
                    <img src="<?php echo htmlspecialchars($image); ?>" class="d-block w-100" alt="Image Slide">
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p>No images available.</p>
        <?php endif; ?>
    </div>
</div>

<script>
    $(document).ready(function(){
        // Configuración del carousel para que pase cada 4.5 segundos
        $('#carouselExampleFade').carousel({
            interval: 4000, // 4.5 segundos entre transiciones
            ride: 'carousel' // Habilitar el carrusel al cargar
        });
    });
</script>

</body>
</html>
