<?php
// Start session first before including any files
if(session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// Check if already logged in, redirect to user.php
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === TRUE) {
    header("Location: user.php");
    exit;
}

include('includes/functions.php');
$table_name = "user";

$data = ['id' => '1','username' => 'admin','password' => 'admin',];
$db->insertIfEmpty($table_name, $data);

$error_message = "";
if (isset($_POST["login"])){
    $username = $_POST["username"];
    $userData = $db->select($table_name, '*', 'username = :username', '', [':username' => $username]);
    if ($userData) {
        $storedPassword = $userData[0]['password'];
        $enteredPassword = $_POST["password"];
        if ($enteredPassword == $storedPassword) {
            session_regenerate_id();
            $_SESSION['loggedin'] = TRUE;
            $_SESSION['name'] = $_POST['username'];
            // Always redirect to user.php after successful login
            header('Location: user.php');
            exit;
        }else{
            $error_message = "Incorrect password. Please try again.";
        }
    }else{
        $error_message = "Username not found. Please check your credentials.";
    }
    $db->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>BouzTV</title>
     <link rel="manifest" href="./img/site.webmanifest">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* Theme variables - using the specified color palette */
        :root {
            /* Dark theme (default) */
            --primary-color: #264653;      /* Dark blue/teal */
            --primary-dark: #1d3540;       /* Darker version of primary */
            --primary-light: #2a9d8f;      /* Teal */
            --accent: #e9c46a;             /* Yellow/Gold */
            --accent-secondary: #f4a261;   /* Light Orange */
            --accent-tertiary: #e76f51;    /* Deep Orange */
            
            --dark-color: #1a2c35;         /* Near black with blue tint */
            --dark-color-secondary: #264653; /* Based on primary */
            --light-color: #f8f9fa;        /* Off white */
            --grey-color: #b0b0b0;         /* Gray */
            
            --error-color: #e76f51;        /* Error messages */
            
            /* Text colors */
            --text-primary: #e0e0e0;        /* Main text - light */
            --text-dark: #264653;          /* Dark text for light mode */
        }
        
        /* Light theme */
        [data-theme="light"] {
            --dark-color: #f8f9fa;          /* Now light */
            --dark-color-secondary: #eaeaea; /* Light gray */
            --light-color: #264653;          /* Now dark */
            --text-primary: #264653;          /* Text now dark */
            --grey-color: #5a7886;           /* Grey darker for contrast */
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            min-height: 100vh;
            background-color: var(--dark-color);
            color: var(--text-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        /* Theme toggle button */
        .theme-toggle {
            position: absolute;
            top: 20px;
            right: 20px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: transparent;
            border: 2px solid var(--primary-light);
            color: var(--text-primary);
            cursor: pointer;
            font-size: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            z-index: 10;
        }
        
        .theme-toggle:hover {
            background-color: var(--primary-light);
            color: var(--light-color);
        }

        /* Flat background styles */
        html {
            background-color: var(--dark-color);
            transition: background-color 0.3s ease;
        }
        
        html[data-theme="dark"] {
            background-color: #1a2c35; /* Flat dark color */
        }
        
        html[data-theme="light"] {
            background-color: #f8f9fa; /* Flat light color */
        }

        .login-container {
            width: 90%;
            max-width: 400px;
            background-color: var(--dark-color-secondary);
            border-radius: 10px;
            padding: 40px 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            color: var(--text-primary);
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        /* Border effect */
        .login-container::before {
            content: '';
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            background: linear-gradient(45deg, var(--primary-light), var(--accent), var(--primary-light));
            z-index: -1;
            border-radius: 12px;
            animation: glowing 20s linear infinite;
            opacity: 0.8;
            transition: all 0.3s ease;
        }
        
        /* Light theme adjustments for login container */
        [data-theme="light"] .login-container {
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        @keyframes glowing {
            0% { background-position: 0 0; }
            50% { background-position: 400% 0; }
            100% { background-position: 0 0; }
        }

        h1 {
            font-size: 24px;
            font-weight: 500;
            margin-bottom: 5px;
            color: var(--text-primary);
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 4px;
            transition: color 0.3s ease;
        }

        .subtitle {
            font-size: 14px;
            color: var(--grey-color);
            margin-bottom: 25px;
            text-align: center;
            transition: color 0.3s ease;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
            text-align: left;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-size: 14px;
            font-weight: 500;
            color: var(--text-primary);
            position: relative;
            left: 15px;
            transition: color 0.3s ease;
        }

        .form-control {
            width: 100%;
            height: 50px;
            padding: 10px 15px;
            padding-left: 45px;
            background-color: var(--dark-color-secondary);
            border: 1px solid var(--primary-light);
            outline: none;
            border-radius: 40px;
            font-size: 16px;
            color: var(--text-primary);
            box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
        }

        [data-theme="light"] .form-control {
            background-color: rgba(255, 255, 255, 0.9);
            box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--primary-light);
        }

        .form-control:focus {
            color: var(--accent);
            border-color: var(--accent);
            box-shadow: 0 0 0 2px rgba(42, 157, 143, 0.25);
        }

        .form-control::placeholder {
            color: var(--grey-color);
        }

        .input-wrapper {
            position: relative;
        }

        .form-icon {
            position: absolute;
            left: 16px;
            top: 16px;
            color: var(--primary-light);
            font-size: 18px;
            z-index: 1;
            transition: color 0.3s ease;
        }
        
        [data-theme="light"] .form-icon {
            color: var(--primary);
        }

        .btn-login {
            width: 100%;
            height: 50px;
            background: var(--primary);
            border: none;
            outline: none;
            border-radius: 40px;
            margin-top: 20px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
            color: var(--light);
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
        }
        
        [data-theme="light"] .btn-login {
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .btn-login:hover {
            background: var(--primary-light);
            transform: translateY(-2px);
            box-shadow: 0 6px 8px rgba(0, 0, 0, 0.3);
        }
        
        [data-theme="light"] .btn-login:hover {
            box-shadow: 0 6px 8px rgba(0, 0, 0, 0.15);
        }

        .btn-login:active {
            background: var(--primary-dark);
            transform: translateY(1px);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        .error-message {
            background-color: rgba(255, 0, 0, 0.15);
            color: #ff7070;
            padding: 12px;
            border-radius: 8px;
            font-size: 14px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            border-left: 3px solid var(--error-color);
        }

        .error-message i {
            margin-right: 10px;
            font-size: 16px;
            color: var(--error-color);
        }

        .footer-text {
            text-align: center;
            font-size: 12px;
            color: var(--grey-color);
            margin-top: 30px;
            transition: color 0.3s ease;
        }

        .footer-text a {
            color: var(--primary-light);
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .footer-text a:hover {
            color: var(--accent);
            text-decoration: underline;
        }
        
        [data-theme="light"] .footer-text a:hover {
            color: var(--accent-tertiary);
        }

        /* Visual equalizer animation at the bottom */
        .equalizer {
            height: 10px;
            width: 100%;
            display: flex;
            justify-content: center;
            margin-top: 20px;
            gap: 3px;
            transition: all 0.3s ease;
        }

        .bar {
            background: var(--primary-light);
            height: 100%;
            width: 8px;
            border-radius: 10px;
            animation: equalize 1.5s infinite ease-in-out;
            transition: background-color 0.3s ease;
        }
        
        [data-theme="light"] .bar {
            background: var(--primary);
        }

        .bar:nth-child(1) { animation-delay: 0.0s; }
        .bar:nth-child(2) { animation-delay: 0.1s; }
        .bar:nth-child(3) { animation-delay: 0.2s; }
        .bar:nth-child(4) { animation-delay: 0.3s; }
        .bar:nth-child(5) { animation-delay: 0.4s; }
        .bar:nth-child(6) { animation-delay: 0.5s; }
        .bar:nth-child(7) { animation-delay: 0.6s; }
        .bar:nth-child(8) { animation-delay: 0.7s; }

        @keyframes equalize {
            0%, 100% { transform: scaleY(0.3); }
            50% { transform: scaleY(1); }
        }
    </style>
</head>

<body>
    <!-- Theme toggle button -->
    <button id="themeToggle" class="theme-toggle" aria-label="Toggle theme">
        <i class="fas fa-sun" id="themeIcon"></i>
    </button>

    <div class="login-container">
        <h1>Login</h1>
        <p class="subtitle">BouzTV Manager</p>

        <?php if (!empty($error_message)): ?>
        <div class="error-message">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo htmlspecialchars($error_message); ?>
        </div>
        <?php endif; ?>

        <form method="post">
            <div class="form-group">
                <label class="form-label">Username</label>
                <div class="input-wrapper">
                    <i class="fas fa-user form-icon"></i>
                    <input type="text" class="form-control" placeholder="Username" name="username" required autofocus>
                </div>
            </div>
            
            <div class="form-group">
                <label class="form-label">Password</label>
                <div class="input-wrapper">
                    <i class="fas fa-lock form-icon"></i>
                    <input type="password" class="form-control" placeholder="••••••••" name="password" required>
                </div>
            </div>
            
            <button type="submit" class="btn-login" name="login">
                Login
            </button>
        </form>

        <div class="equalizer">
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
            <div class="bar"></div>
        </div>
        
        <p class="footer-text">
            <a href="https://t.me/BouzTV" target="_blank">BouzTV</a>
        </p>
    </div>

    <script src="https://code.jquery.com/jquery-3.3.1.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    
    <script>
    $(document).ready(function() {
        // Theme switching functionality
        function setTheme(themeName) {
            // Set theme attribute on html element
            document.documentElement.setAttribute('data-theme', themeName);
            
            // Update the icon
            if (themeName === 'light') {
                $('#themeIcon').removeClass('fa-sun').addClass('fa-moon');
            } else {
                $('#themeIcon').removeClass('fa-moon').addClass('fa-sun');
            }
            
            // Save theme preference to localStorage
            localStorage.setItem('theme', themeName);
        }
        
        // Toggle between dark and light themes
        function toggleTheme() {
            if (localStorage.getItem('theme') === 'light') {
                setTheme('dark');
            } else {
                setTheme('light');
            }
        }
        
        // Set initial theme from localStorage or default to dark
        (function() {
            if (localStorage.getItem('theme') === 'light') {
                setTheme('light');
            } else {
                setTheme('dark');
            }
        })();
        
        // Handle theme toggle button click
        $('#themeToggle').click(function() {
            toggleTheme();
        });
    });
    </script>
</body>

</html>